-- judgment ticks
local tickState = {
	CurSelection = nil,		-- selection index
	CurState = nil,			-- are ticks enabled? (bool)
}
if ThemePrefs.Get("JudgeTicks") ~= nil then
	tickState.CurState = ThemePrefs.Get("JudgeTicks")
	tickState.CurSelection = ThemePrefs.Get("JudgeTicks") and 1 or 2
end

local focusColor = color("1,1,1,1")
local unfocusColor = color("0.5,0.5,0.5,1")

return Def.ActorFrame{
	Def.Actor{
		Name="InputController";
		NewStateMessageCommand=function(self,p)
			local menuState = p.MenuState
			if menuState.CurState == "JudgmentTicks" then
				-- this should only happen if the preference wasn't read:
				if not tickState.CurSelection then
					tickState.CurSelection = 2
					tickState.CurState = false
				end
			end
		end;
		ThemeOptionsSubInputMessageCommand=function(self,p)
			local menuState = p.MenuState
			if menuState.CurState == "JudgmentTicks" then
				local curItem = tickState.CurSelection
				local oldItem = curItem
				if p.Input == "Start" then
					-- save setting
					ThemePrefs.Set("JudgeTicks",curItem == 1)
					-- send input back to main
					menuState.CurState = nil
					menuState.JudgeStyle = curItem
					MESSAGEMAN:Broadcast("NewState", { MenuState = menuState })
				else
					if p.Input == "Up" then
						curItem = (curItem == 1) and 2 or 1
						tickState.CurSelection = curItem
						MESSAGEMAN:Broadcast("UpdateTickOption",{ New=curItem, Old=oldItem })
					elseif p.Input == "Down" then
						curItem = (curItem == 1) and 2 or 1
						tickState.CurSelection = curItem
						MESSAGEMAN:Broadcast("UpdateTickOption",{ New=curItem, Old=oldItem })
					end
				end
				tickState.CurState = (tickState.CurSelection == 1)
			end
		end;
	};

	Def.ActorFrame{
		Name="TickOptions";
		InitCommand=cmd(x,SCREEN_CENTER_X+166;CenterY);
		BeginCommand=function(self)
			if ThemePrefs.Get("JudgeTicks") ~= nil then
				self:GetChild("TicksOn"):playcommand(tickState.CurState and "GainFocus" or "LoseFocus")
				self:GetChild("TicksOff"):playcommand(tickState.CurState and "LoseFocus" or "GainFocus")
			else
				self:GetChild("TicksOn"):playcommand("LoseFocus")
				self:GetChild("TicksOff"):playcommand("GainFocus")
			end
		end;
		UpdateTickOptionMessageCommand=function(self,p)
			self:GetChild("TicksOn"):playcommand( p.New == 1 and "GainFocus" or "LoseFocus" )
			self:GetChild("TicksOff"):playcommand( p.New == 2 and "GainFocus" or "LoseFocus" )
		end;

		LoadFont("_francophilsans Bold 24px")..{
			Name="TicksOn";
			InitCommand=cmd(y,-54;shadowlength,1;halign,0;zoom,18/24);
			BeginCommand=cmd(settext,"On");
			GainFocusCommand=cmd(diffuse,focusColor);
			LoseFocusCommand=cmd(diffuse,unfocusColor);
			SelectedCommand=cmd(diffuse,color("1,0.8,0,1"));
		};
		LoadFont("_francophilsans Bold 24px")..{
			Name="TicksOff";
			InitCommand=cmd(y,-34;shadowlength,1;halign,0;zoom,18/24);
			BeginCommand=cmd(settext,"Off");
			GainFocusCommand=cmd(diffuse,focusColor);
			LoseFocusCommand=cmd(diffuse,unfocusColor);
			SelectedCommand=cmd(diffuse,color("1,0.8,0,1"));
		};
	};
};
